package fm.qingting.demo;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.bumptech.glide.Glide;


import java.util.List;

import fm.qingting.qtsdk.QTException;
import fm.qingting.qtsdk.QTSDK;
import fm.qingting.qtsdk.callbacks.QTCallback;
import fm.qingting.qtsdk.entity.SimpleChannel;


/**
 * Created by lee on 2018/1/23.
 */

public class CollectActivity extends AppCompatActivity {
    RecyclerView recyclerView;
    SimpleAdapter listAdapter;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_collect);
        recyclerView = findViewById(R.id.list);
        listAdapter = new SimpleAdapter<SimpleChannel>() {
            @Override
            public void bindData(SimpleAdapter.SimpleHolder holder, final SimpleChannel object) {
                holder.mTextView.setText(object.getTitle());
                Glide.with(holder.itemView.getContext()).load(object.getThumb()).into(holder.mImageView);
                holder.mLinearLayout.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        Intent intent = new Intent(v.getContext(), DetailsActivity.class);
                        intent.putExtra(DetailsActivity.CHANNEL_ID, object.getChannelId());
                        v.getContext().startActivity(intent);
                    }
                });
            }
        };
        recyclerView.setLayoutManager(new LinearLayoutManager(getBaseContext()));
        recyclerView.setAdapter(listAdapter);
        requestCollectList();
    }

    private void requestCollectList() {
        QTSDK.requestFavChannel(new QTCallback<List<SimpleChannel>>() {
            @Override
            public void done(List<SimpleChannel> result, QTException e) {
                if (e == null) {
                    listAdapter.items = result;
                    listAdapter.notifyDataSetChanged();
                }
            }
        });
    }
}
